#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    int index;
    double x, y;
} Point;

typedef struct {
    int u, v;
} Edge;

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Point *points = (Point*)malloc(n * sizeof(Point));
    for (int i = 0; i < n; i++) {
        points[i].index = i+1;
        scanf("%lf %lf", &points[i].x, &points[i].y);
    }

    // Step 1: Build grid
    int k = (int)ceil(1.0/eps);
    Point **grid = (Point**)calloc(k*k, sizeof(Point*));
    int *taken = (int*)calloc(k*k, sizeof(int));

    for (int i = 0; i < n; i++) {
        int gx = (int)(points[i].x * k);
        int gy = (int)(points[i].y * k);
        if (gx == k) gx = k-1;
        if (gy == k) gy = k-1;
        int idx = gx*k + gy;
        if (!taken[idx]) {
            grid[idx] = &points[i];
            taken[idx] = 1;
        }
    }

    // Step 2: Collect Q
    Point *Q = (Point*)malloc(k*k * sizeof(Point));
    int q_size = 0;
    for (int i = 0; i < k*k; i++) {
        if (taken[i]) {
            Q[q_size++] = *grid[i];
        }
    }

    printf("%d\n", q_size);
    for (int i = 0; i < q_size; i++) {
        printf("%d%c", Q[i].index, i==q_size-1 ? '\n' : ' ');
    }

    // Step 3: Build a simple MST: connect points in order
    for (int i = 1; i < q_size; i++) {
        printf("%d %d\n", Q[i-1].index, Q[i].index);
    }

    free(points);
    free(grid);
    free(taken);
    free(Q);
    return 0;
}